/*
Réception de données avec envoi d'accusé de réception

Protocole :
- réception d'un message + <CR>
- envoi de l'accusé de réception "OK" + <CR>

NB : positionner "retour chariot" pour le moniteur série
et la bonne vitesse de transmission
*/

#include <SoftwareSerial.h>

const bool debug = false;

// NB : positionner RX = 10 et TX = 11 pour une Arduino MEGA
const int RX = ...;    // pin Shield Arduino pour reception
const int TX = ...;    // pin Shield Arduino pour transmission

const int baudRate = 9600;

const char *PANID = "...";      // adresse reseau
const char *MYID  = "...";      // adresse du XBee
const char *DLID  = "...";      // adresse de destination
const char *CHID  = "...";      // n° de canal

SoftwareSerial xbeeSerial(TX, RX);     // pin 2 = RX Arduino, pin3 = TX Arduino

void setup()
{
  Serial.begin(baudRate);            // liaison série de la console (débugage)
  xbeeSerial.begin(baudRate);        // Liaison série du module XBEE
  
  Serial.println("init");
  setXBEE("+++");

  // attente réponse OK de la commande AT
  char thisByte = 0;
  while ( thisByte != '\r' )
    if ( xbeeSerial.available() > 0 ) {
      thisByte = xbeeSerial.read();
      Serial.print(thisByte);
      }
  Serial.println("");

  char  buffer[11];
  setXBEE("ATRE\r");        // configuration usine par defaut
  setXBEE(strcat(strcat(strcpy(buffer,"ATID"), PANID), "\r"));    // adresse du reseau PAN
  setXBEE(strcat(strcat(strcpy(buffer,"ATMY"), MYID), "\r"));    // set my address using 16-bit addressing
  setXBEE(strcat(strcat(strcpy(buffer,"ATDL"), DLID), "\r"));    // adresse de destination sur 16 bits  
  setXBEE(strcat(strcat(strcpy(buffer,"ATCH"), CHID), "\r"));    // canal 3
  setXBEE("ATDH0\r");       // pas de partie haute, adresse 16 bits
  setXBEE("ATCE0\r");        // end device
  setXBEE("ATWR\r");        // enregistrement
  setXBEE("ATCN\r");        // put the radio in data mode
    
  // attente réponse commandes AT
  while ( xbeeSerial.available() < 0 );
  
  char c = xbeeSerial.read();
  while ( c != -1 ) {
    if ( c != '\r' )
      Serial.print(c);
    else
      Serial.print(" ");
    c = xbeeSerial.read();
    }
  Serial.println("ready to receive");
}

void loop()
{
  char  inputByte = xbeeSerial.read();

  if ( inputByte > 0 ) {
	  if ( debug )
		  Serial.print(inputByte, HEX);
	
    if ( inputByte == '\r' ) {   // caractère de fin (CR = 0x0D)
      xbeeSerial.print("OK\r");
      Serial.println("");
      }
    else
      Serial.print(inputByte);
    }
}

void setXBEE(char *buffer)
{ 
  Serial.println(buffer);
  Serial.print("sent: "); Serial.println(xbeeSerial.print(buffer));
  delay(100);
}

