/*
Mesure du temps de transmission
NB : positionner "retour chariot" pour le moniteur série
et la bonne vitesse de transmission
*/

#include <SoftwareSerial.h>

// NB : positionner RX = 10 et TX = 11 pour une Arduino MEGA
const int RX = ...;    // pin Shield Arduino pour reception
const int TX = ...;    // pin Shield Arduino pour transmission

const int baudRate = 9600;

const char *PANID = "...";      // adresse reseau
const char *MYID  = "...";      // adresse du XBee
const char *DLID  = "...";      // adresse de destination
const char *CHID  = "...";         // n° de canal

SoftwareSerial xbeeSerial(TX, RX);     // pin 2 = RX Arduino, pin3 = TX Arduino

const unsigned int MAXSIZE = 64;
unsigned int i = 0;

void setup()
{
  // initialize serial communications at 9600 bps:
  Serial.begin(baudRate);            // liaison série de la console (débugage)
  xbeeSerial.begin(baudRate);        // Liaison série du module XBEE
  
  Serial.println("init");
  setXBEE("+++");

  // attente réponse OK de la commande AT
  char thisByte = 0;
  while ( thisByte != '\r' )
    if ( xbeeSerial.available() > 0 ) {
      thisByte = xbeeSerial.read();
      Serial.print(thisByte);
      }
  Serial.println("");

  char  buffer[11];
  setXBEE("ATRE\r");        // configuration usine par defaut
  setXBEE(strcat(strcat(strcpy(buffer,"ATID"), PANID), "\r"));    // adresse du reseau PAN
  setXBEE(strcat(strcat(strcpy(buffer,"ATMY"), MYID), "\r"));    // set my address using 16-bit addressing
  setXBEE(strcat(strcat(strcpy(buffer,"ATDL"), DLID), "\r"));    // adresse de destination sur 16 bits  
  setXBEE(strcat(strcat(strcpy(buffer,"ATCH"), CHID), "\r"));    // canal 3
  setXBEE("ATDH0\r");       // pas de partie haute, adresse 16 bits
  setXBEE("ATCE0\r");       // end device
  setXBEE("ATWR\r");        // enregistrement
  setXBEE("ATCN\r");        // put the radio in data mode
  
  // vide le tampon d'entrée
  xbeeSerial.flush();
  Serial.println("ready to send");
}

void loop()
{
  if ( Serial.available() > 0 ) {
    // saisie via terminal
    char outputByte;
    do {
      outputByte = Serial.read();
      if ( outputByte != -1 )
        xbeeSerial.print(outputByte);
      } while ( outputByte != '\r' );

    // attente réponse XBee distant
    while ( xbeeSerial.available() < 0 );

    // lecture liaison serie
    char buffer[MAXSIZE], inputByte;
    do {
      inputByte = xbeeSerial.read();
      if ( inputByte != -1 )
        buffer[i++] = inputByte;
      } while ( inputByte != '\r' );
     
    // affichage code retour
    buffer[i] = 0;
    Serial.println(buffer);
    i = 0;
  }
}

void setXBEE(char *buffer)
{ 
  Serial.println(buffer);
  Serial.print("sent: "); Serial.println(xbeeSerial.print(buffer));
  delay(100);
}

