/*
commandes à distances
*/

#include <SoftwareSerial.h>
#include <Servo.h>

const bool debug = false;

// NB : positionner RX = 10 et TX = 11 pour une Arduino MEGA
const int RX = ...;    // pin Shield Arduino pour reception
const int TX = ...;    // pin Shield Arduino pour transmission

const int baudRate = 9600;

const char *PANID = "...";      // adresse reseau
const char *MYID  = "...";      // adresse du XBee
const char *DLID  = "...";      // adresse de destination
const char *CHID  = "...";         // n° de canal

const int ledR  = ...;    // LED rouge
const int ledB  = ...;    // LED blanche
const int servo = ...;    // servomoteur
const int lux   = ...;   // luxmètre
const int temp  = ...;   // thermomètre

SoftwareSerial xbeeSerial(TX, RX);     // pin 2 = RX Arduino, pin3 = TX Arduino
Servo myServo;                           // création de l'objet servo issu du moule Servo

char buffer[64];
unsigned int i = 0, angle = 0;

void setup()
{
  // initialise les sorties
  pinMode(ledB, OUTPUT);
  pinMode(ledR, OUTPUT);
  
  // on accroche notre servomoteur
  myServo.attach(servo);
  myServo.write(angle);
  
  Serial.begin(baudRate);            // liaison série de la console (débugage)
  xbeeSerial.begin(baudRate);        // Liaison série du module XBEE
  
  Serial.println("init");
  setXBEE("+++");

  // attente réponse OK de la commande AT
  char thisByte = 0;
  while ( thisByte != '\r' )
    if ( xbeeSerial.available() > 0 ) {
      thisByte = xbeeSerial.read();
      Serial.print(thisByte);
      }
  Serial.println("");

  char  buffer[11];
  setXBEE("ATRE\r");        // configuration usine par defaut
  setXBEE(strcat(strcat(strcpy(buffer,"ATID"), PANID), "\r"));    // adresse du reseau PAN
  setXBEE(strcat(strcat(strcpy(buffer,"ATMY"), MYID), "\r"));    // set my address using 16-bit addressing
  setXBEE(strcat(strcat(strcpy(buffer,"ATDL"), DLID), "\r"));    // adresse de destination sur 16 bits  
  setXBEE(strcat(strcat(strcpy(buffer,"ATCH"), CHID), "\r"));    // canal 3
  setXBEE("ATDH0\r");       // pas de partie haute, adresse 16 bits
  setXBEE("ATCE0\r");        // end device
  setXBEE("ATWR\r");        // enregistrement
  setXBEE("ATCN\r");        // put the radio in data mode
    
  // attente réponse commandes AT
  while ( xbeeSerial.available() < 0 );
  
  char c = xbeeSerial.read();
  while ( c != -1 ) {
    if ( c != '\r' )
      Serial.print(c);
    else
      Serial.print(" ");
    c = xbeeSerial.read();
    }
  
  Serial.println("ready to receive");
}

void loop()
{
  char  inputByte = xbeeSerial.read();

  if ( inputByte > 0 ) {
    buffer[i++] = inputByte;
    if ( debug )
      Serial.print(inputByte, HEX);
    
    if ( inputByte == '\r' ) {   // caractère de fin (CR)
      buffer[i] = 0;
      i = 0;
    
      // analyse syntaxe des commandes reçues
      xbeeSerial.print(parsing(buffer));

      Serial.println("");
      }
    else
      Serial.print(inputByte);
    }
}

const char *parsing(const char *cmd)
{
  // commande luxmètre
  if ( !strncmp(cmd, "LUX", 3) )
    return strcat(itoa(analogRead(lux), buffer, 10), "\r");
  
  // commande thermomètre
  if ( !strncmp(cmd, "TEMP", 4) )
    return strcat(itoa(analogRead(temp), buffer, 10), "\r");
  
  // commande servo moteur
  if ( !strncmp(cmd, "SERV", 4) )
    switch ( cmd[4] ) {
      case '=':
        return move(&cmd[6]);
      default:
        return strcat(itoa(angle, buffer, 10), "\r");
      }
  
  // commande LED
  if ( !strncmp(cmd, "LED ", 4) )
    switch ( cmd[4] ) {
      case 'R':
        return flash(&cmd[5], ledR);
      case 'B':
        return flash(&cmd[5], ledB);
      default:
        return "ERROR\r";
      }
    
  return "ERROR\r";
}

const char *move(const char *cmd)
{
  const int value = atoi(cmd);

  if ( value < 0 || value > 180 )
    return "ERROR\r";

  if ( value > angle )
    while ( value > angle ) {
      myServo.write(++angle);
      delay(10);
      }
  else
    if ( value < angle )
      while ( value < angle ) {
        myServo.write(--angle);
        delay(10);
        }
      
  return "OK\r";
}

const char *flash(const char *cmd, const int output)
{
  if ( !strncmp(cmd, "=ON", 3) )
    digitalWrite(output, HIGH);
  else
    if ( !strncmp(cmd, "=OFF", 4) )
      digitalWrite(output, LOW);
    else
      return "ERROR\r";
      
  return "OK\r";
}

void setXBEE(char *buffer)
{ 
  Serial.println(buffer);
  Serial.print("sent: "); Serial.println(xbeeSerial.print(buffer));
  delay(100);
}

