def moyenne(tab : list) -> float:
    """
    @param	tab -- tableau de nombres flottants
    @return	la moyenne des valeurs du tableau, ou None si tableau vide
    """
    total = 0
    for n in tab:
        total += n
    return total / len(tab) if len(tab) else None

assert moyenne([1.0]) == 1.0
assert moyenne([1.0, 2.0, 4.0]) == 2.3333333333333335
assert moyenne([5,3,8]) == 5.333333333333333
assert moyenne([1,2,3,4,5,6,7,8,9,10]) == 5.5
assert moyenne([]) is None


def tri(tab : list):
    '''tab est un tableau d'entiers contenant des 0 et des 1.
    La fonction trie ce tableau en plaçant tous les 0 à gauche'''
    i = 0 # premier indice de la zone non triÃ©e 
    j = len(tab) - 1 # dernier indice de la zone non triÃ©e 
    while i < j:
        if tab[i]== 0:
            i = i + 1 
        else:
            valeur = tab[j] 
            tab[j] = 1 
            tab[i] = valeur
            j = j - 1
            
tab = [0,1,0,1,0,1,0,1,0]
tri(tab)
assert tab == [0, 0, 0, 0, 0, 1, 1, 1, 1]