def moyenne(notes : list) -> float:
    """
    @param	notes -- tableau (notes, coeff), donné en paramètre.
    @return la moyenne pondérée des résultats
    """
    total, coef = 0., 0
    for n in notes:
        total += n[0] * n[1]
        coef  += n[1]
    return total / coef if coef else None

assert moyenne([(15.0, 2), (9.0, 1), (12.0, 3)]) == 12.5
assert moyenne([(15.0, 0), (9.0, 0), (12.0, 0)]) is None
assert moyenne([]) is None


def ligne_suivante(ligne : list) -> list:
    '''Renvoie la ligne suivant ligne du triangle de Pascal'''
    ligne_suiv = [1] 
    for i in range(1, len(ligne)): 
        ligne_suiv.append(ligne[i-1]+ligne[i]) 
    ligne_suiv.append(1) 
    return ligne_suiv

def pascal(n : int) -> list:
    '''Renvoie le triangle de Pascal de hauteur n'''
    triangle = [ [1] ]
    for k in range(1,n+1): 
        ligne_k =ligne_suivante(triangle[k-1])
        triangle.append(ligne_k)
    return triangle

assert ligne_suivante([1, 3, 3, 1]) == [1, 4, 6, 4, 1]
assert pascal(2) == [[1], [1, 1], [1, 2, 1]]
assert pascal(3) == [[1], [1, 1], [1, 2, 1], [1, 3, 3, 1]]
