def recherche(tab : list, x : int) -> bool:
    """
    @param	tab -- tableau d'entiers trié dans l'ordre croissant
    @param	n -- nombre entier n, et qui effectue une recherche di-
    @return	indice correspondant au nombre cherché s’il est dans tab, None sinon.
    """
    debut = 0
    fin   = len(tab) - 1
    while debut <= fin:
        m = (debut + fin) // 2 
        if x == tab[m]:
            return m 
        if x > tab[m]:
            debut = m + 1
        else:
            fin = m - 1 
    return None 

assert recherche([2, 3, 4, 5, 6], 5) == 3
assert recherche([2, 3, 4, 6, 7], 5) is None
assert recherche([15, 16, 18, 19, 23, 24, 28, 29, 31, 33], 28) == 6
assert recherche([15, 16, 18, 19, 23, 24, 28, 29, 31, 33], 27) is None
        

alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'

def position_alphabet(lettre):
    '''Renvoie la position de la lettre dans l'alphabet'''
    return ord(lettre) - ord('A')

def cesar(message, decalage):
    '''Renvoie le message codé par la méthode de César
    pour le decalage donné'''
    resultat = ''
    for c in message: 
        if 'A' <= c and c <= 'Z':
            indice = (position_alphabet(c) + decalage) % 26 
            resultat = resultat + alphabet[indice]
        else:
            resultat = resultat + c 
    return resultat

assert cesar('BONJOUR A TOUS. VIVE LA MATIERE NSI !', 4) == 'FSRNSYV E XSYW. ZMZI PE QEXMIVI RWM !'
assert cesar('GTSOTZW F YTZX. ANAJ QF RFYNJWJ SXN !', -5) == 'BONJOUR A TOUS. VIVE LA MATIERE NSI !'
