def ecriture_binaire_entier_positif(n : int) -> str:
    """
    @param	un entier positif n
    @return	chaine de caractère correspondant à l’écriture binaire de n.
    """
    assert n >= 0
    
    bin = str(n%2)
    n   = n // 2
    while n > 0:
        bin = str(n%2) + bin
        n   = n //2
    return bin

assert ecriture_binaire_entier_positif(0) == '0'
assert ecriture_binaire_entier_positif(2) == '10'
assert ecriture_binaire_entier_positif(105) == '1101001'


def echange(tab, i, j):
    '''Echange les éléments d'indice i et j dans le tableau tab.'''
    temp = tab[i]
    tab[i] = tab[j]
    tab[j] = temp

def tri_bulles(tab):
    '''Trie le tableau tab dans l'ordre croissant
    par la méthode du tri à  bulles.'''
    n = len(tab)
    for i in range(n-1): 
        for j in range(n-i-1): 
            if tab[j] > tab[j+1]: 
                echange(tab, j, j+1) 

tab = []
tri_bulles(tab)
assert tab == []

tab = [9, 3, 7, 2, 3, 1, 6]
tri_bulles(tab)
assert tab == [1, 2, 3, 3, 6, 7, 9]

tab = [9, 7, 4, 3]
tri_bulles(tab)
assert tab == [3, 4, 7, 9]
