def fibonacci(n : int) -> int:
    """
    @param	n -- un entier n > 0
    @return	le terme d’indice n de cette suite.
    """
    assert n > 0
    
    tab    = [0]*(n+1)
    tab[1] = 1
    for i in range(2, n+1):
        tab[i] = tab[i-1] + tab[i-2]
    return tab[n]

assert fibonacci(1) == 1
assert fibonacci(2) == 1
assert fibonacci(25) == 75025


def eleves_du_mois(eleves : list, notes : list) -> tuple:
    """
    @param	eleves -- nom des élèves
    @param	notes -- entiers positifs désignant leur note à un contrôle
    @return	le couple constitué de la note maximale attribuée
        et des noms des élèves ayant obtenu cette note regroupés dans un tableau.
    """
    note_maxi = 0
    meilleurs_eleves = [] 

    for i in range(len(eleves)): 
        if notes[i] == note_maxi: 
            meilleurs_eleves.append(eleves[i]) 
        elif notes[i] > note_maxi:
            note_maxi = notes[i] 
            meilleurs_eleves = [eleves[i]] 

    return (note_maxi, meilleurs_eleves)

eleves_nsi = ['a','b','c','d','e','f','g','h','i','j']
notes_nsi  = [30, 40, 80, 60, 58, 80, 75, 80, 60, 24]
assert eleves_du_mois(eleves_nsi, notes_nsi) == (80, ['c', 'f', 'h'])
