def voisins_entrants(adj : list, x : int) -> list:
    """
    @param  adj -- le graphe donné sous forme de liste d’adjacence
    @param  x -- un sommet du graphe
    @return une liste contenant les voisins entrants du sommet x
            c’est-à-dire les sommets y tels qu’il existe une arête de y vers x.
    """
    liste  = []
    sommet = 0
    for voisin in adj:
        if x in voisin:
            liste  += [sommet]
        sommet += 1
    return liste

assert voisins_entrants([[1, 2], [2], [0], [0]], 0) == [2, 3]
assert voisins_entrants([[1, 2], [2], [0], [0]], 1) == [0]


def nombre_suivant(s):
    '''Renvoie le nombre suivant de celui representé par s
    en appliquant le procédé de lecture.'''
    resultat = ''
    chiffre = s[0]
    compte = 1
    for i in range(1, len(s)):
        if s[i] == chiffre:
            compte += 1
        else:
            resultat += str(compte) + chiffre
            chiffre = s[i]
            compte = 1
    lecture_chiffre = str(compte) + chiffre
    resultat += lecture_chiffre
    return resultat

assert nombre_suivant('1211') == '111221'
assert nombre_suivant('311') == '1321'
