def recherche(tab : list, n : int) -> int:
    """
    @brief  effectue une recherche dichotomique du nombre entier n dans le tableau non vide
    @param  tab -- un tableau tab de nombres entiers triés par ordre croissant
    @param  n -- un nombre entier n
    @return un indice correspondant au nombre cherché s’il est dans le tableau, None sinon.
    """
    assert len(tab)

    debut = 0
    fin   = len(tab) - 1
    while debut <= fin:
        m = (debut + fin) // 2
        if n == tab[m]:
            return m
        if n > tab[m]:
            debut = m + 1
        else:
            fin = m - 1
    return None

assert recherche([2, 3, 4, 5, 6], 5) == 3
assert recherche([2, 3, 4, 6, 7], 5) is None


alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'

def position_alphabet(lettre):
    '''Renvoie la position de la lettre dans l'alphabet'''
    return ord(lettre) - ord('A')

def cesar(message, decalage):
    '''Renvoie le message codé par la méthode de César
    pour le decalage donné'''
    resultat = ''
    for c in message:
        if 'A' <= c and c <= 'Z':
            indice = (position_alphabet(c) + decalage) % 26
            resultat = resultat + alphabet[indice]
        else:
            resultat = resultat + c
    return resultat

assert cesar('BONJOUR A TOUS. VIVE LA MATIERE NSI !', 4) == 'FSRNSYV E XSYW. ZMZI PE QEXMIVI RWM !'
assert cesar('GTSOTZW F YTZX. ANAJ QF RFYNJWJ SXN !', -5) == 'BONJOUR A TOUS. VIVE LA MATIERE NSI !'
