def enumere(tab : list) -> dict:
    """
    @param  tab -- un tableau
    @return un dictionnaire d dont les clés sont les éléments de tab
            avec pour valeur associée la liste des indices de l’élément dans le tableau tab.
    """
    dico = {}
    for i in range(len(tab)):
        if tab[i] in dico:
            dico[tab[i]] += [i]
        else:
            dico[tab[i]]  = [i]
    return dico

assert enumere([]) == {}
assert enumere([1, 2, 3]) == {1: [0], 2: [1], 3: [2]}
assert enumere([1, 1, 2, 3, 2, 1]) == {1: [0, 1, 5], 2: [2, 4], 3: [3]}


class Noeud:
    """Classe représentant un noeud d'un arbre binaire"""
    def __init__(self, etiquette, gauche, droit):
        """Crée un noeud de valeur etiquette avec
        gauche et droit comme fils."""
        self.etiquette = etiquette
        self.gauche = gauche
        self.droit = droit

def parcours(arbre, liste):
    """parcours récursivement l'arbre en ajoutant les étiquettes
    de ses noeuds à la liste passée en argument en ordre infixe."""
    if arbre != None:
        parcours(arbre.gauche, liste)
        liste.append(arbre.etiquette)
        parcours(arbre.droit, liste)
    return liste

def insere(arbre, cle):
    """insere la cle dans l'arbre binaire de recherche
    représenté par arbre.
    Retourne l'arbre modifié."""
    if arbre == None:
        return Noeud(cle, None, None) # creation d'une feuille
    else:
        if cle < arbre.etiquette:
            arbre.gauche = insere(arbre.gauche, cle)
        else:
            arbre.droit = insere(arbre.droit, cle)
        return arbre

abr = Noeud(5, None, None)
assert insere(None, 5).etiquette == 5
assert parcours(abr, []) == [5]
for i in [2, 7, 3]:
    insere(abr, i)
assert parcours(abr, []) == [2, 3, 5, 7]
for i in [1, 4, 6, 8]:
    insere(abr, i)
assert parcours(abr, []) == [1, 2, 3, 4, 5, 6, 7, 8]
