def indices_maxi(tab : list) -> tuple:
    """
    @param  tab -- tableau non vide de nombre entiers
    @return un tuple (maxi, indices)
            • maxi est le plus grand élément de tab ;
            • indices tableu contenant les indices de tab où apparaît ce plus grand élément.
    """
    assert len(tab)

    liste = []
    maxi  = 0
    for i in range(1, len(tab)):
        if tab[i] > tab[maxi]:
            maxi = i
    for i in range(len(tab)):
        if tab[i] == tab[maxi]:
            liste += [i]
    return tab[maxi], liste

assert indices_maxi([1, 5, 6, 9, 1, 2, 3, 7, 9, 8]) == (9, [3, 8])
assert indices_maxi([7]) == (7, [0])


def renverse(pile):
    '''renvoie une pile contenant les mêmes éléments que pile,
    mais dans l'ordre inverse.
    Cette fonction détruit pile.'''
    pile_inverse = []
    while pile != []:
        pile_inverse.append(pile.pop())
    return pile_inverse


def positifs(pile):
    '''renvoie une pile contenant les éléments positifs de pile,
    dans le même ordre. Cette fonction détruit pile.'''
    pile_positifs = []
    while pile != []:
        item = pile.pop()
        if item >= 0:
            pile_positifs = [item] + pile_positifs
    return pile_positifs

assert renverse([1, 2, 3, 4, 5]) == [5, 4, 3, 2, 1]
assert positifs([-1, 0, 5, -3, 4, -6, 10, 9, -8]) == [0, 5, 4, 10, 9]
assert positifs([-2]) == []
