def multiplication(n1 : int, n2 : int) -> int:
    """
    @param  n1 -- nombre entier relatif
    @param  n2 -- nombre entier relatif
    @return le produit de ces deux nombres.
    @remark Les seules opérations arithmétiques autorisées sont l’addition et la soustraction.
    """
    somme = 0
    n = n1 if n1 > 0 else -n1
    for i in range(n):
        somme += n2
    return somme if n1 > 0 else -somme

assert multiplication(3, 5) == 15
assert multiplication(-4, -8) == 32
assert multiplication(-2, 6) == -12
assert multiplication(-2, 0) == 0
assert multiplication(0, -2) == 0


def dichotomie(tab, x):
    """
    tab : tableau d'entiers trié dans l'ordre croissant
    x : nombre entier
    La fonction renvoie True si tab contient x et False sinon
    """
    debut = 0
    fin   = len(tab) - 1
    while debut <= fin:
        m = (debut + fin) // 2
        if x == tab[m]:
            return True
        if x > tab[m]:
            debut = m + 1
        else:
            fin = m - 1
    return False

assert dichotomie([15, 16, 18, 19, 23, 24, 28, 29, 31, 33], 28) is True
assert dichotomie([15, 16, 18, 19, 23, 24, 28, 29, 31, 33], 27) is False
