def fusion(tab1 : list, tab2 : list) -> list:
    """
    @param  tab1, tab2 -- deux tableaux non vides d’entiers, chacun dans l’ordre croissant
    @return un tableau trié dans l’ordre croissant et contenant l’ensemble des valeurs de tab1 et tab2.
    """
    tableau = []
    indice = 0
    for n in tab1:
        while indice < len(tab2) and tab2[indice] <= n:
            tableau += [tab2[indice]]
            indice  += 1
        tableau += [n]
    while indice < len(tab2):
        tableau += [tab2[indice]]
        indice  += 1
    return tableau

assert fusion([3, 5], [2, 5]) == [2, 3, 5, 5]
assert fusion([-2, 4], [-3, 5, 10]) == [-3, -2, 4, 5, 10]
assert fusion([4], [2, 6]) == [2, 4, 6]
assert fusion([], []) == []
assert fusion([1, 2, 3], []) == [1, 2, 3]


romains = {"I":1, "V":5, "X":10, "L":50, "C":100, "D":500, "M":1000}

def traduire_romain(nombre):
    """ Renvoie l'écriture décimale du nombre donné en chiffres
    romains """
    if len(nombre) == 1:
        return romains[nombre[0]]
    elif romains[nombre[0]] >= romains[nombre[1]]:
        return +romains[nombre[0]] + traduire_romain(nombre[1:])
    else:
        return -romains[nombre[0]] + traduire_romain(nombre[1:])

assert traduire_romain("XIV") == 14
assert traduire_romain("CXLII") == 142
assert traduire_romain("MMXXIV") == 2024
