def moyenne(liste : list) -> float:
    """
    @param  liste --  une liste notes non vide de tuples à deux éléments entiers
                      de la forme (note, coefficient) (int ou float) positifs ou nuls ;
    @return la moyenne pondérée des notes de la liste sous forme de flottant
            si la somme des coefficients est non nulle, None sinon.
    """
    somme, total = 0, 0
    for note, coefficient in liste:
        somme += note * coefficient
        total += coefficient
    return somme / total if total else None

assert moyenne([(8, 2), (12, 0), (13.5, 1), (5, 0.5)]) == 9.142857142857142
assert moyenne([(3, 0), (5, 0)]) is None
assert moyenne([(15.0,2),(9.0,1),(12.0,3)]) == 12.5


def ligne_suivante(ligne):
    '''Renvoie la ligne suivant ligne du triangle de Pascal'''
    ligne_suiv = [ligne[0]]
    for i in range(1, len(ligne)):
        ligne_suiv.append(ligne[i-1] + ligne[i])
    ligne_suiv.append(ligne[0])
    return ligne_suiv

def pascal(n):
    '''Renvoie le triangle de Pascal de hauteur n'''
    triangle = [ [1] ]
    for k in range(1, n+1):
        ligne_k = ligne_suivante(triangle[k-1])
        triangle.append(ligne_k)
    return triangle

assert ligne_suivante([1, 3, 3, 1]) == [1, 4, 6, 4, 1]
assert pascal(2) == [[1], [1, 1], [1, 2, 1]]
assert pascal(3) == [[1], [1, 1], [1, 2, 1], [1, 3, 3, 1]]
