def ajoute_dictionnaires(d1 : dict, d2 : dict) -> dict:
    """
    @param  d1 et d2 dictionnaires dont les clés sont des nombres
    @return le dictionnaire d défini de la façon suivante :
            • les clés de d sont celles de d1 et celles de d2 réunies ;
            • si une clé est présente dans les deux dictionnaires d1 et d2, sa valeur associée dans
              le dictionnaire d est la somme de ses valeurs dans les dictionnaires d1 et d2 ;
            • si une clé n’est présente que dans un des deux dictionnaires, sa valeur associée dans
              le dictionnaire d est la même que sa valeur dans le dictionnaire où elle est présente.
    """
    dico = d1
    for k in d2:
        if k in dico:
            dico[k] += d2[k]
        else:
            dico[k]  = d2[k]
    return dico

assert ajoute_dictionnaires({1: 5, 2: 7}, {2: 9, 3: 11}) == {1: 5, 2: 16, 3: 11}
assert ajoute_dictionnaires({}, {2: 9, 3: 11}) == {2: 9, 3: 11}
assert ajoute_dictionnaires({1: 5, 2: 7}, {}) == {1: 5, 2: 7}


from random import randint

def nombre_coups():
    '''Simule un jeu de plateau avec 12 cases et renvoie le nombre
    minimal de coups pour visiter toutes les cases.'''
    nombre_cases = 12
    # indique si une case a été vue
    cases_vues = [ False ] * nombre_cases
    nombre_cases_vues = 1
    cases_vues[0] = True
    case_en_cours = 0
    n = [case_en_cours]
    while nombre_cases_vues < nombre_cases:
        x = randint(1, 6)
        case_en_cours = (case_en_cours + x) % nombre_cases
        if cases_vues[case_en_cours] is False:
            cases_vues[case_en_cours] = True
            nombre_cases_vues = nombre_cases_vues + 1
        n = n + [case_en_cours]
    return n

cases_vues = nombre_coups()
assert len(cases_vues) >= 12
for i in range(12):
    assert i in cases_vues