def verifie(tab : list) -> bool:
    """
    @param  tab -- un tableau de valeurs numériques
    @return True si ce tableau est trié dans l’ordre croissant, False sinon.
    @remark Un tableau vide est considéré comme trié.
    """
    if len(tab) < 2:
        return True
    a = tab[0]
    for i in range(1, len(tab)):
        b = tab[i]
        if b < a:
            return False
        else:
            a = b
    return True

assert verifie([0, 5, 8, 8, 9]) == True
assert verifie([8, 12, 4]) == False
assert verifie([-1, 4]) == True
assert verifie([]) == True
assert verifie([5]) == True


def depouille(urne):
    '''prend en paramètre une liste de suffrages et renvoie un
    dictionnaire avec le nombre de voix pour chaque candidat'''
    resultat = {}
    for bulletin in urne:
        if bulletin in resultat:
            resultat[bulletin] = resultat[bulletin] + 1
        else:
            resultat[bulletin] = 1
    return resultat

def vainqueurs(election):
    '''prend en paramètre un dictionnaire non vide avec le nombre de voix
    pour chaque candidat et renvoie la liste des vainqueurs'''
    nmax = 0
    for candidat in election:
        if election[candidat] > nmax :
           nmax = election[candidat]
    liste_finale = [ nom for nom in election if election[nom] == nmax ]
    return liste_finale

assert depouille([ 'A', 'B', 'A' ]) == {'A': 2, 'B': 1}
assert depouille([]) == {}
assert depouille(['A', 'A', 'A', 'B', 'C', 'B', 'C', 'B', 'C', 'B']) == {'A': 3, 'B': 4, 'C': 3}
assert vainqueurs({'A': 3, 'B': 4, 'C': 3}) == ['B']
assert vainqueurs({ 'A' : 2, 'B' : 2, 'C' : 1}) == ['A', 'B']
