def renverse(mot : str) -> str:
    """ renvoie une chaîne de caractères en inversant ceux de la chaîne mot. """
    s = ""
    for i in range(len(mot)-1, -1, -1):
        s += mot[i]
    return s

assert renverse("informatique") == "euqitamrofni"
assert renverse("i") == "i"
assert renverse("") == ""


def crible(n):
    """
    Renvoie un tableau contenant tous les nombres premiers plus petits que n
    """
    premiers = []
    tab = [True] * n
    tab[0], tab[1] = False, False   # attention n > 1
    for i in range(2, n):
        if tab[i] == True:
            premiers.append(i)
            for multiple in range(2 * i, n, i):
                tab[multiple] = False
    return premiers

assert crible(2) == []
assert crible(3) == [2]
assert crible(40) == [2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37]
