def fibonacci(n : int) ->int:
    """
    @param  n -- entier > 0
    @return résultat du terme d’indice n de la suite de fibonacci
    """
    if n < 1:
        return None
    suite = [0] * (n+1)
    for i in range(1, n+1):
        if i < 3:
            suite[i] = 1
        else:
            suite[i] = suite[i-1] + suite[i-2]
    return suite[n]

assert fibonacci(0) == None
assert fibonacci(1) == 1
assert fibonacci(2) == 1
assert fibonacci(3) == 2
assert fibonacci(4) == 3
assert fibonacci(5) == 5
assert fibonacci(6) == 8
assert fibonacci(7) == 13
assert fibonacci(8) == 21
assert fibonacci(25) == 75025
assert fibonacci(45) == 1134903170


def pantheon(eleves, notes):
    note_maxi = 0
    meilleurs_eleves = []
    for i in range(len(notes)):
        if notes[i] == note_maxi:
            meilleurs_eleves.append(eleves[i])
        elif notes[i] > note_maxi:
            note_maxi = notes[i]
            meilleurs_eleves = [eleves[i]]
    return (note_maxi, meilleurs_eleves)

assert pantheon(['a'], [24]) == (24, ['a'])
assert pantheon(['a','b','c','d','e','f','g','h','i','j'], [30, 40, 80, 60, 58, 80, 75, 80, 60, 24]) == (80, ['c', 'f', 'h'])
assert pantheon([],[]) == (0, [])
