def recherche(elt : int, tab : list) -> int:
    """
    @param   elt -- nombre entier
    @param   tab -- tableau de nombres entiers
    @return  l’indice de la dernière occurrence de elt dans tab si elt est dans tab et -1 sinon.
    """
    indice = -1
    for i in range(len(tab)):
        if tab[i] == elt:
            indice = i
    return indice

assert recherche(1, [2, 3, 4]) == -1
assert recherche(1, [10, 12, 1, 56]) == 2
assert recherche(1, [1, 0, 42, 7]) == 0
assert recherche(1, [1, 50, 1]) == 2
assert recherche(1, [8, 1, 10, 1, 7, 1, 8]) == 5


class AdresseIP:
    def __init__(self, adresse):
        self.adresse = adresse

    def liste_octet(self):
        """renvoie une liste de nombres entiers,
           la liste des octets de l'adresse IP"""
        return [int(i) for i in self.adresse.split(".")]

    def est_reservee(self):
        """renvoie True si l'adresse IP est une adresse
           reservee, False sinon"""
        return self.adresse == '192.168.0.255' or self.adresse == '192.168.0.0'

    def adresse_suivante(self):
        """renvoie un objet de AdresseIP avec l'adresse
           IP qui suit l'adresse self
           si elle existe et False sinon"""
        if int(self.adresse.split('.')[3]) < 254:
            octet_nouveau = int(self.adresse.split('.')[3]) + 1
            return AdresseIP('192.168.0.' + str(octet_nouveau))
        else:
            return False

assert AdresseIP('192.168.0.1').est_reservee() == False
assert AdresseIP('192.168.0.0').est_reservee() == True
assert AdresseIP('192.168.0.255').est_reservee() == True
assert AdresseIP('192.168.0.2').adresse_suivante().adresse == '192.168.0.3'
assert AdresseIP('192.168.0.253').adresse_suivante().adresse == '192.168.0.254'
assert AdresseIP('192.168.0.254').adresse_suivante() == False
