def couples_consecutifs(tab : list) -> list:
    """
    @param  tab -- liste non vide de nombres entiers
    @return liste (éventuellement vide) des couples d'entiers consécutifs successifs qu'il peut y avoir dans tab.
    """
    if len(tab) < 2:
        return []
    l = []
    for i in range(len(tab)-1):
        a, b = tab[i], tab[i+1]
        if (a == b-1) and (a < b):
            l.append((a, b))
    return l

assert couples_consecutifs([]) == []
assert couples_consecutifs([1]) == []
assert couples_consecutifs([1, 1]) == []
assert couples_consecutifs([1, 2]) == [(1,2)]
assert couples_consecutifs([1, 4, 3, 5]) == []
assert couples_consecutifs([1, 4, 5, 3]) == [(4, 5)]
assert couples_consecutifs([1, 1, 2, 4]) == [(1, 2)]
assert couples_consecutifs([7, 1, 2, 5, 3, 4]) == [(1, 2), (3, 4)]
assert couples_consecutifs ([5, 1, 2, 3, 8, -5, -4, 7]) == [(1, 2), (2, 3), (-5, -4)]


def propager(M, i, j, val):
    if M[i][j] == 1:
        M[i][j] = val

    # l'element en haut fait partie de la composante
    if i-1 >= 0 and M[i-1][j] == 1:
        propager(M, i-1, j, val)

    # l'element en bas fait partie de la composante
    if i+1 < len(M) and M[i+1][j] == 1:
        propager(M, i+1, j, val)

    # l'element à gauche fait partie de la composante
    if j-1 >= 0 and M[i][j-1] == 1:
        propager(M, i, j-1, val)

    # l'element à droite fait partie de la composante
    if j+1 < len(M[0]) and M[i][j+1] == 1:
        propager(M, i, j+1, val)

    return M

assert propager([[0, 0, 1], [0, 1, 0], [1, 1, 1], [0, 1, 1]], 2, 1, 3) == [[0, 0, 1], [0, 3, 0], [3, 3, 3], [0, 3, 3]]
assert propager([[0, 0, 1, 0], [0, 1, 0, 1], [1, 1, 1, 0], [0, 1, 1, 0]], 2, 1, 3) == [[0, 0, 1, 0], [0, 3, 0, 1], [3, 3, 3, 0], [0, 3, 3, 0]]
