def taille(arbre : dict, lettre : str) -> int:
    """
    @param  arbre -- arbre binaire arbre
    @param  lettre -- valeur du sommet de a
    @return taille de l’arbre, à savoir le nombre total de nœud.
    @remark arbre[lettre][0] permet d’atteindre la clé du sous-arbre gauche
    """
    if lettre == '':
        return 0
    if arbre[lettre][0] == '' and arbre[lettre][1] == '':
        return 1
    return 1 + taille(arbre, arbre[lettre][0]) + taille(arbre, arbre[lettre][1])

a = {
    'F':['B','G'], 'B':['A','D'], 'A':['',''], 'D':['C','E'], \
    'C':['',''], 'E':['',''], 'G':['','I'], 'I':['','H'], \
    'H':['','']}

assert taille(a, 'F') == 9


def tri_selection(tab):
    N = len(tab)
    for k in range(N):
        imin = k
        for i in range(imin+1, N):
            if tab[i] < tab[imin]:
                imin = i
        tab[k] , tab[imin] = tab[imin] , tab[k]
    #return tab

liste = [41, 55, 21, 18, 12, 6, 25]
tri_selection(liste)
assert liste == [6, 12, 18, 21, 25, 41, 55]

#tri_selection([41, 55, 21, 18, 12, 6, 25]) == [6, 12, 18, 21, 25, 41, 55]
#tri_selection([1]) == [1]
#tri_selection([1, 2]) == [1, 2]
#tri_selection([2, 1]) == [1, 2]
#tri_selection([]) == []
