def min_et_max(tab : list) -> dict:
    """ renvoie la plus petite et la plus grande valeur du tableau sous la forme d’un dictionnaire à deux clés 'min' et 'max'.
    @warning    L’utilisation des fonctions natives min, max et sorted, ainsi que la méthode sort n’est pas autorisée.
    """
    min = tab[0]
    max = tab[0]
    for t in tab:
        if min > t:
            min = t
        elif max < t:
            max = t
    return {'min': min, 'max': max}

assert min_et_max([0, 1, 4, 2, -2, 9, 3, 1, 7, 1]) == {'min': -2, 'max': 9}
assert min_et_max([0, 1, 2, 3]) == {'min': 0, 'max': 3}
assert min_et_max([3]) == {'min': 3, 'max': 3}
assert min_et_max([1, 3, 2, 1, 3]) == {'min': 1, 'max': 3}
assert min_et_max([-1, -1, -1, -1, -1]) == {'min': -1, 'max': -1}


class Carte:
    def __init__(self, c, v):
        """ Initialise les attributs couleur (entre 1 et 4), et valeur (entre 1 et 13). """
        self.couleur = c
        self.valeur = v

    def get_valeur(self):
        """ Renvoie la valeur de la carte : As, 2, ..., 10, Valet, Dame, Roi """
        valeurs = ['As','2', '3', '4', '5', '6', '7', '8', '9', '10', 'Valet', 'Dame', 'Roi']
        return valeurs[self.valeur - 1]

    def get_couleur(self):
        """ Renvoie la couleur de la carte (parmi pique, coeur, carreau, trèfle). """
        couleurs = ['pique', 'coeur', 'carreau', 'trèfle']
        return couleurs[self.couleur - 1]

class Paquet_de_cartes:
    def __init__(self):
        """ Initialise l'attribut contenu avec une liste des 52 objets Carte possibles
            rangés par valeurs croissantes en commençant par pique, puis coeur,
            carreau et tréfle. """
        self.cartes = []
        for couleur in range(1, 5):
            for valeur in range(1, 14):
                self.cartes.append(Carte(couleur, valeur))

    def get_carte(self, pos):
        """ Renvoie la carte qui se trouve à la position pos (entier compris entre 0 et 51). """
        if 51 < pos or pos < 0 :
            raise AssertionError('paramètre pos invalide')
        return self.cartes[pos]

jeu = Paquet_de_cartes()
assert jeu.get_carte(0).get_valeur() == 'As'
assert jeu.get_carte(10).get_valeur() == 'Valet'
assert jeu.get_carte(10).get_couleur() == 'pique'

carte1 = jeu.get_carte(20)
assert carte1.get_valeur() + " de " + carte1.get_couleur() == '8 de coeur'
carte2 = jeu.get_carte(0)
assert carte2.get_valeur() + " de " + carte2.get_couleur() == 'As de pique'
jeu.get_carte(52)  #AssertionError : paramètre pos invalide
