class Arbre:
    def __init__(self, etiquette):
        self.v = etiquette
        self.fg = None
        self.fd = None

def taille(a : Arbre) -> int:
    """
    @return la taille de l’arbre a
    @remark Si un arbre a un seul nœud, sa taille = 1.
    @remark S’il est vide, sa taille = 0.
    """
    if a is None:
        return 0
    if (a.fg is None) and (a.fd is None):
        return 1
    else:
        return 1 + taille(a.fg) + taille(a.fd)

a = Arbre(1)
a.fg = Arbre(4)
a.fd = Arbre(0)
a.fd.fd = Arbre(7)

assert taille(None) == 0
assert taille(Arbre(1)) == 1
assert taille(a) == 4

def hauteur(a : Arbre) -> int:
    """
    @return la hauteur de l’arbre a
    @remark Si un arbre a un seul nœud, sa hauteur = 1.
    @remark S’il est vide, sa hauteur = 0.
    """
    if a is None:
        return 0
    if (a.fg is None) and (a.fd is None):
        return 1
    else:
        return 1 + max(hauteur(a.fg), hauteur(a.fd))

assert hauteur(None) == 0
assert hauteur(Arbre(1)) == 1
assert hauteur(a) == 3

a = Arbre(0)
a.fg = Arbre(1)
a.fg.fg = Arbre(3)
a.fd = Arbre(2)
a.fd.fg = Arbre(4)
a.fd.fg.fd = Arbre(6)
a.fd.fd = Arbre(5)

assert taille(a) == 7
assert hauteur(a) == 4


def ajoute(indice, element, liste):
    nbre_elts = len(liste)
    L = [0 for i in range(nbre_elts + 1)]
    if indice < nbre_elts:
        for i in range(indice):
            L[i] = liste[i]
        L[indice] = element
        for i in range(indice + 1, nbre_elts + 1):
            L[i] = liste[i-1]
    else:
        for i in range(nbre_elts):
            L[i] = liste[i]
        L[nbre_elts] = element
    return L

assert ajoute(1, 4, [7, 8, 9]) == [7, 4, 8, 9]
assert ajoute(3, 4, [7, 8, 9]) == [7, 8, 9, 4]
assert ajoute(4, 4, [7, 8, 9]) == [7, 8, 9, 4]