def multiplication(n1 : int, n2 : int) -> int:
    """
    @param  n1 -- entier relatif
    @param  n2 -- entier relatif
    @return le produit de ces deux nombres.
    @warning Les seules opérations autorisées sont l’addition et la soustraction.
    """
    resultat = 0
    positif  = (n1 < 0 and n2 < 0) or (n1 >= 0 and n2 >= 0)
    if n1 < 0:
        n1 = -n1
    if n2 < 0:
        n2 = -n2
    for _ in range(n1):
        resultat += n2
    return resultat if positif else -resultat

assert multiplication(3, 5) == 15
assert multiplication(-4, -8) == 32
assert multiplication(-2, 6) == -12
assert multiplication(6, -2) == -12
assert multiplication(-2, 0) == 0
assert multiplication(0, -2) == 0


def dichotomie(tab, x):
    """
    tab : tableau d'entiers trie dans l'ordre croissant
    x   : nombre entier
    La fonction renvoie True si tab contient x et False sinon
    """
    debut = 0
    fin = len(tab) - 1
    while debut <= fin:
        m = (debut + fin) // 2
        if x == tab[m]:
            return True
        if x > tab[m]:
            debut = m + 1
        else:
             fin = m - 1
    return False

assert dichotomie([15, 16, 18, 19, 23, 24, 28, 29, 31, 33], 28) == True
assert dichotomie([15], 15) == True
assert dichotomie([15, 16], 15) == True
assert dichotomie([15, 16], 16) == True
assert dichotomie([], 15) == False
assert dichotomie([15, 16, 18, 19, 23, 24, 28, 29, 31, 33], 27) == False