def nbr_occurrences(chaîne : str) -> dict:
    """
    @return dictionnaire des nombres d’occurrences des caractères de chaîne.
    """
    dico = {}
    for c in chaîne:
        if c in dico:
            dico[c] += 1
        else:
            dico[c]  = 1
    return dico

assert nbr_occurrences('') == {}
assert nbr_occurrences('Hello world !') == {'H': 1, 'e': 1, 'l': 3, 'o': 2, ' ': 2, 'w': 1, 'r': 1, 'd': 1, '!': 1}


def fusion(lst1, lst2):
    n1 = len(lst1)
    n2 = len(lst2)
    lst12 = [0] * (n1 + n2)
    i1 = 0
    i2 = 0
    i = 0
    while i1 < n1 and i2 < n2 :
        if lst1[i1] < lst2[i2]:
            lst12[i] = lst1[i1]
            i1 = i1 + 1
        else:
            lst12[i] = lst2[i2]
            i2 = i2 + 1
        i += 1
    while i1 < n1:
        lst12[i] = lst1[i1]
        i1 = i1 + 1
        i = i + 1
    while i2 < n2:
        lst12[i] = lst2[i2]
        i2 = i2 + 1
        i = i + 1
    return lst12

assert fusion([], []) == []
assert fusion([1], []) == [1]
assert fusion([], [1]) == [1]
assert fusion([1], [2]) == [1, 2]
assert fusion([2], [1]) == [1, 2]
assert fusion([1, 6, 10], [0, 7, 8, 9]) == [0, 1, 6, 7, 8, 9, 10]
