def recherche(tab : list, n : int) -> int:
    """ recherche dichotomique du nombre entier n dans le tableau non vide tab.
    @param  tab -- tableau de nombres entiers triés par ordre croissant
    @param  n -- nombre entier
    @return indice correspondant au nombre cherché s’il est dans le tableau, -1 sinon
    """
    a, b = 0, len(tab)-1
    while a <= b:
        m = (a + b) // 2
        if tab[m] < n:
            a = m + 1
        elif tab[m] > n:
            b = m - 1
        else:
            return m
    return -1

assert recherche([], 5) == -1
assert recherche([5], 5) == 0
assert recherche([2, 3, 4, 5, 6], 2) == 0
assert recherche([2, 3, 4, 5, 6], 6) == 4
assert recherche([2, 3, 4, 5, 6], 5) == 3
assert recherche([2, 3, 4, 6, 7], 5) == -1
assert recherche([2, 3, 4, 6], 4) == 2


ALPHABET = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'

def position_alphabet(lettre):
    return ord(lettre) - ord('A')

def cesar(message, decalage):
    resultat = ''
    for c in message:
        if 'A' <= c and c <= 'Z':
            indice = (position_alphabet(c) + decalage) % 26
            resultat = resultat + ALPHABET[indice]
        else:
            resultat = resultat + c
    return resultat

assert cesar('BONJOUR A TOUS. VIVE LA MATIERE NSI !', 4) == 'FSRNSYV E XSYW. ZMZI PE QEXMIVI RWM !'
assert cesar(cesar('BONJOUR A TOUS. VIVE LA MATIERE NSI !', 4), -4)== 'BONJOUR A TOUS. VIVE LA MATIERE NSI !'
assert cesar('GTSOTZW F YTZX. ANAJ QF RFYNJWJ SXN !', -5) == 'BONJOUR A TOUS. VIVE LA MATIERE NSI !'