def moyenne(liste_notes : list) -> float:
    """ calcule la moyenne pondérée des résultats
    @param  liste_notes -- liste non vide, contient des couples (note, coefficient)
    @remark note est un nombre de type float compris entre 0 et 20 ;
    @remark coefficient est un nombre entier strictement positif.
    @return moyenne pondérée
    """
    total_note = 0
    total_coef = 0
    for note, coef in liste_notes:
        total_note += note * coef
        total_coef += coef
    return round(total_note / total_coef, 1) if total_coef else -1

assert moyenne([(15, 2)]) == 15
assert moyenne([(15, 2), (9, 1), (12, 3)]) == 12.5
assert moyenne([(15, 0), (9, 0), (12, 0)]) == -1
assert moyenne([]) == -1


def pascal(n):
    triangle= [[1]]
    for k in range(1, n+1):
        ligne_k = [1]
        for i in range(1, k):
            ligne_k.append(triangle[k-1][i-1] + triangle[k-1][i])
        ligne_k.append(1)
        triangle.append(ligne_k)
    return triangle

assert pascal(0) == [[1]]
assert pascal(1) == [[1], [1, 1]]
assert pascal(2) == [[1], [1, 1], [1, 2, 1]]
assert pascal(3) == [[1], [1, 1], [1, 2, 1], [1, 3, 3, 1]]
assert pascal(4) == [[1], [1, 1], [1, 2, 1], [1, 3, 3, 1], [1, 4, 6, 4, 1]]
assert pascal(5) == [[1], [1, 1], [1, 2, 1], [1, 3, 3, 1], [1, 4, 6, 4, 1], [1, 5, 10, 10, 5, 1]]
