t_moy  = [14.9, 13.3, 13.1, 12.5, 13.0, 13.6, 13.7]
annees = [2013, 2014, 2015, 2016, 2017, 2018, 2019]

def mini(releve : list, date : list) ->tuple:
    """
    @param  releve -- tableau des relevés
    @param  date -- tableau des dates
    @return la plus petite valeur relevée au cours de la période et l’année correspondante.
    @remark On suppose que la température minimale est atteinte une seule fois.
    """
    if len(releve) == 0 or len(releve) != len(date):
        return None

    indice = 0
    mini   = t_moy[0]
    for i in range(1, len(releve)):
        if mini > releve[i]:
            mini = releve[i]
            indice = i
    return releve[indice], date[indice]


assert mini(t_moy, annees) == (12.5, 2016)


def inverse_chaine(chaine):
    result = ""
    for caractere in chaine:
       result = caractere + result
    return result

def est_palindrome(chaine):
    inverse = inverse_chaine(chaine)
    return inverse == chaine

def est_nbre_palindrome(nbre):
    chaine = str(nbre)
    return est_palindrome(chaine)

assert inverse_chaine('bac') == 'cab'
assert inverse_chaine('baac') == 'caab'
assert inverse_chaine('a') == 'a'
assert inverse_chaine('') == ''

assert est_palindrome('NSI') == False
assert est_palindrome('ISN-NSI') == True

assert est_nbre_palindrome(214312) == False
assert est_nbre_palindrome(213312) == True
