#------------EXERCICE 1---------------------------
#---------ajout d'une valeur dans un ABR----------
class ABR:
    def __init__(self, g0, v0, d0):
        self.gauche = g0
        self.cle = v0
        self.droit = d0

    def __repr__(self):
        if self is None:
            return ''
        else:
            return '(' + (self.gauche).__repr__() + ',' + str(self.cle) + ',' +(self.droit).__repr__() + ')'

abr = ABR(ABR(None, 0, None), 1, ABR(None, 2, ABR(None, 3, None)))

def ajoute(cle,a):
    if a.cle > cle:
        if a.gauche is None:
            a.gauche = ABR(None, cle, None)
            return abr
        else:
            return ajoute(cle, a.gauche)
    elif a.cle < cle:
        if a.droit is None:
            a.droit = ABR(None, cle, None)
            return abr
        else:
            return ajoute(cle, a.droit)
    else:
        return abr

print(ajoute(4,abr))
print(ajoute(-5, abr))
print(ajoute(2, abr))


#------------EXERCICE 2---------------------------
#-------algorithme glouton de mise en boite-------
def empaqueter(liste_masses, c):
    n = len(liste_masses)
    nb_boites = 0
    boites = [0]*n
    for masse in liste_masses :
        i=0
        while i <= nb_boites and boites[i] + masse > c:
            i = i + 1
        if i == nb_boites + 1:
            nb_boites += 1
        boites[i] = boites[i] + masse
    return nb_boites + 1

assert empaqueter([1, 5, 2], 5) == 2
#assert empaqueter([11, 15, 12], 5) == 0    bug si capacité insuffisante !!
assert empaqueter([7, 6, 3, 4, 8, 5, 9, 2], 11) == 5
