def convertir(tab):
    """
    tab est un tableau d'entiers, dont les éléments sont 0 ou 1,
    et représentant un entier écrit en binaire.
    Renvoie l'écriture décimale de l'entier positif dont la
    représentation binaire est donnée par le tableau tab
    """
    decimal = 0
    power = len(tab) - 1
    for t in tab:
        decimal += t * 2**power
        power   -= 1
    return decimal

assert convertir([0]) == 0
assert convertir([1]) == 1
assert convertir([1, 1]) == 3
assert convertir([1, 0, 1, 0, 0, 1, 1]) == 83
assert convertir([1, 0, 0, 0, 0, 0, 1, 0]) == 130


## Exercice 2
def tri_insertion(tab):
    n = len(tab)
    for i in range(1, n):
        valeur_insertion = tab[i]
        # la variable j sert à déterminer où placer la valeur à ranger
        j = i
        # tant qu'on a pas trouvé la place de l'élément à insérer
        # on décale les valeurs du tableau vers la droite
        while j > 0 and valeur_insertion < tab[j-1]:
            tab[j] = tab[j-1]
            j = j-1
        tab[j] = valeur_insertion
    return tab

assert tri_insertion([]) == []
assert tri_insertion([9]) == [9]
assert tri_insertion([9, 9]) == [9, 9]
assert tri_insertion([9, 5, 8, 4, 0, 2, 7, 1, 10, 3, 6]) == [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
