﻿# -*- coding: utf-8 -*-

def multiplication(n1 : int, n2 : int) -> int:
    """
    @param  n1 -- entier relatif
    @param  n2 -- entier relatif
    @return le produit de ces deux nombres.
    @warning Les seules opérations autorisées sont l’addition et la soustraction.
    """
    resultat = 0
    positif  = (n1 < 0 and n2 < 0) or (n1 >= 0 and n2 >= 0)
    if n1 < 0:
        n1 = -n1
    if n2 < 0:
        n2 = -n2
    for _ in range(n1):
        resultat += n2
    return resultat if positif else -resultat

assert multiplication(3, 5) == 15
assert multiplication(-4, -8) == 32
assert multiplication(-2, 6) == -12
assert multiplication(6, -2) == -12
assert multiplication(-2, 0) == 0
assert multiplication(0, -2) == 0


def chercher(tab, n, i, j):
    if i < 0 or j > len(tab):
        return None
    elif i > j:
        return None
    m = (i + j) // 2
    if tab[m] < n:
        return chercher(tab, n, m+1, j)
    elif tab[m] > n:
        return chercher(tab, n, i, m-1)
    else:
        return m

assert chercher([1, 5, 6, 6, 9, 12], 7, 0, 10) == None
assert chercher([1, 5, 6, 6, 9, 12], 7, 0, 5) == None
assert chercher([1, 5, 6, 6, 9, 12], 9, 0, 5) == 4
assert chercher([1, 5, 6, 6, 9, 12], 6, 0, 5) == 2
