def max_dico(dico : dict) -> tuple:
    """
    @param  dico --  dictionnaire dico non vide
    @remark les clés sont des chaînes de caractères et les valeurs associées sont des entiers >= 0
    @retval la première valeur est une clé du dictionnaire associée à la valeur maximale ;
    @retval la seconde valeur est la valeur maximale présente dans le dictionnaire.
    """
    name, max = None, -1
    for key, value in dico.items():
        if max < value:
            name, max = key, value
    return name, max

assert max_dico({}) == (None, -1)
assert max_dico({'Bob': 102, 'Ada': 201, 'Alice': 103, 'Tim': 50}) == ('Ada', 201)
assert max_dico({'Alan': 222, 'Ada': 201, 'Eve': 220, 'Tim': 50}) == ('Alan', 222)
assert max_dico({'Alan': 222, 'Ada': 201, 'Eve': 222, 'Tim': 50}) in [('Eve', 222), ('Alan', 222)]


class Pile:
    """
    Classe definissant une structure de pile.
    """
    def __init__(self):
        self.contenu = []

    def est_vide(self):
        """
        Renvoie le booleen True si la pile est vide, False sinon.
        """
        return self.contenu == []

    def empiler(self, v):
        """
        Place l'element v au sommet de la pile
        """
        self.contenu.append(v)

    def depiler(self):
        """
        Retire et renvoie l'element place au sommet de la pile,
        si la pile n'est pas vide.
        """
        if not self.est_vide():
            return self.contenu.pop()


def eval_expression(tab):
    p = Pile()
    for element in tab:
        if element != '+' and element != '*':
            p.empiler(element)
        else:
            if element == '+':
                resultat = p.depiler() + p.depiler()
            else:
                resultat = p.depiler() * p.depiler()
            p.empiler(resultat)
    return p.depiler()

assert eval_expression([2, 3, '+', 5, '*']) == 25
assert eval_expression([2, 3, '*', 5, '*']) == 30
assert eval_expression([2, 3, '+', 5, '+']) == 10
assert eval_expression([2, 3, '+', 5, '*', 5, '+', 6, '*']) == 180
assert eval_expression([]) == None

