def fusion(tab1 : list, tab2 : list) -> list:
    """
    @param  tab1 -- tableaux non vides d'entiers d’ordre croissant
    @param  tab2 -- tableaux non vides d'entiers d’ordre croissant
    @return tableau trié dans l’ordre croissant et contenant l’ensemble des valeurs de tab1 et tab2.
    """
    #return sorted(tab1 + tab2) # ha ha ha !
    tab = []

    i1, i2 = 0, 0
    n1, n2 = len(tab1), len(tab2)
    while (i1 < n1) and (i2 < n2):
        if tab1[i1] <= tab2[i2]:
            tab.append(tab1[i1])
            i1 += 1
        else:
            tab.append(tab2[i2])
            i2 += 1
    for i in range(i1, n1):
        tab.append(tab1[i])
    for i in range(i2, n2):
        tab.append(tab2[i])

    return tab

assert fusion([], []) == []
assert fusion([3, 5], [2, 5]) == [2, 3, 5, 5]
assert fusion([-2, 4], [-3, 5, 10]) == [-3, -2, 4, 5, 10]
assert fusion([4], [2, 6]) == [2, 4, 6]


romains = {"I":1, "V":5, "X":10, "L":50, "C":100, "D":500, "M":1000}

def traduire_romain(nombre) :
    """ Renvoie l'ecriture decimale du nombre donné en chiffres romains """
    if len(nombre) == 1:
        return romains[nombre]

    elif romains[nombre[0]] >= romains[nombre[1]] :
        return romains[nombre[0]] + traduire_romain(nombre[1:])
    else:
        return -romains[nombre[0]] + traduire_romain(nombre[1:])

assert traduire_romain("XIV") == 14
assert traduire_romain("CXLII") == 142
assert traduire_romain("MMXXIII") == 2023
