from random import randint

def lancer(n : int) ->list:
    """
    @param n -- un entier positif
    @return list de n entiers obtenus aléatoirement entre 1 et 6 (1 et 6 inclus)
    """
    l = []
    for i in range(n):
        l.append(randint(1,6))
    return l

def paire_6(tab : list) -> bool:
    """
    @param  tab -- un tableau de n entiers entre 1 et 6
    @return  True si le nombre de 6 est supérieur ou égal à 2, False sinon.
    """
    count = 0
    for item in tab:
        if item == 6:
            count += 1
    return count > 1

assert len(lancer(5)) == 5
assert len(lancer(3)) == 3
assert len(lancer(0)) == 0
assert paire_6([5, 6, 6, 2, 2]) == True
assert paire_6([6, 5, 1, 6, 6]) == True
assert paire_6([2, 2, 6]) == False
assert paire_6([]) == False


def nbLig(image):
    '''renvoie le nombre de lignes de l'image'''
    return len([x for x in image])

def nbCol(image):
    '''renvoie la largeur de l'image'''
    return len([x for x in image[0]])

def negatif(image):
    '''renvoie le negatif de l'image sous la forme
       d'une liste de listes'''

    # on cree une image de 0 aux memes dimensions que le parametre image
    L = [[0 for k in range(nbCol(image))] for i in range(nbLig(image))]

    for i in range(nbLig(image)):
        for j in range(nbCol(image)):
            L[i][j] = 255 - image[i][j]
    return L

def binaire(image, seuil):
    '''renvoie une image binarisee de l'image sous la forme
       d'une liste de listes contenant des 0 si la valeur
       du pixel est strictement inferieure au seuil
       et 1 sinon'''

    # on cree une image de 0 aux memes dimensions que le parametre image
    L = [[0 for k in range(nbCol(image))] for i in range(nbLig(image))]

    for i in range(nbLig(image)):
        for j in range(nbCol(image)):
            if image[i][j] < seuil :
                L[i][j] = 0
            else:
                L[i][j] = 1
    return L

img=[[20, 34, 254, 145, 6], [23, 124, 237, 225, 69], [197, 174, 207, 25, 87], [255, 0, 24, 197, 189]]
assert nbLig(img) == 4
assert nbCol(img) == 5
assert negatif(img) == [[235, 221, 1, 110, 249], [232, 131, 18, 30, 186], [58, 81, 48, 230, 168], [0, 255, 231, 58, 66]]
assert binaire(img,120) == [[0, 0, 1, 1, 0], [0, 1, 1, 1, 0], [1, 1, 1, 0, 0], [1, 0, 0, 1, 1]]