def recherche(elt : int, tab : list):
    """ renvoie le tableau des indices de elt dans tab si elt est
    dans tab et le tableau vide [] sinon."""
    liste = []
    for i in range(len(tab)):
        if tab[i] == elt:
            liste.append(i)
    return liste

assert recherche(3, [3, 2, 1, 3, 2, 1]) == [0, 3]
assert recherche(4, [1, 2, 3]) == []


resultats = {'Dupont':{'DS1' : [15.5, 4],
                       'DM1' : [14.5, 1],
                       'DS2' : [13, 4],
                       'PROJET1' : [16, 3],
                       'DS3' : [14, 4]},
             'Durand':{'DS1' : [6 , 4],
                       'DM1' : [14.5, 1],
                       'DS2' : [8, 4],
                       'PROJET1' : [9, 3],
                       'IE1' : [7, 2],
                       'DS3' : [8, 4],
                       'DS4' :[15, 4]},
             'Moi':{'DS1' : [10 , 1]},
             'Lui':{'DS1' : [11 , 2]},
             'Toi':{'DS1' : [4 , 1],
                    'DS2' : [10 , 2]}}

def moyenne(nom):
    if nom in resultats:
        notes = resultats[nom]
        total_points = 0
        total_coefficients = 0
        for valeurs in notes.values():
            note , coefficient = valeurs
            total_points = total_points + note * coefficient
            total_coefficients = total_coefficients + coefficient
        return round(total_points / total_coefficients, 1)
    else:
        return -1

assert moyenne('dupont') == -1
assert moyenne('Moi') == 10
assert moyenne('Lui') == 11
assert moyenne('Toi') == 8
assert moyenne('Dupont') == 14.5
assert moyenne('Durand')== 9.2
