def verifie(tab :list) -> bool:
    """ renvoie True si ce tableau est trié dans l’ordre croissant, False sinon."""
    if len(tab) == 0:
        return False

    precedent = tab[0]
    for suivant in tab:
        if suivant < precedent:
            return False
        precedent = suivant
    return True

assert verifie([0, 5, 8, 8, 9]) == True
assert verifie([8, 12, 4]) == False
assert verifie([-1, 4]) == True
assert verifie([5]) == True


def depouille(urne):
    resultat = {}
    for bulletin in urne:
        if bulletin in resultat:
            resultat[bulletin] = resultat[bulletin] + 1
        else:
            resultat[bulletin] = 1
    return resultat

def vainqueur(election):
    vainqueur = ''
    nmax = 0
    for candidat in election:
        if election[candidat] >nmax:
            nmax = election[candidat]
            vainqueur = candidat
    liste_finale = [nom for nom in election if election[nom] == nmax]
    return liste_finale

assert depouille([]) == {}
assert vainqueur(depouille([])) == []
assert depouille(['Oreilles sales', 'Oreilles sales', 'Extra Vomit']) == {'Extra Vomit': 1, 'Oreilles sales': 2}
assert vainqueur(depouille(['Oreilles sales', 'Oreilles sales', 'Extra Vomit'])) == ['Oreilles sales']
assert depouille(['Oreilles sales', 'Extra Vomit']) == {'Extra Vomit': 1, 'Oreilles sales': 1}
assert vainqueur(depouille(['Oreilles sales', 'Extra Vomit'])) == ['Oreilles sales', 'Extra Vomit']

urne = ['Oreilles sales', 'Oreilles sales', 'Oreilles sales',
      'Extra Vomit', 'Lady Baba', 'Extra Vomit', 'Lady Baba',
      'Extra Vomit', 'Lady Baba', 'Extra Vomit']
assert depouille(urne) == {'Extra Vomit': 4, 'Oreilles sales': 3, 'Lady Baba': 3}
assert vainqueur(depouille(urne)) == ['Extra Vomit']
