def convertir(T : list) -> int:
    """
    T est un tableau d'entiers, dont les éléments sont 0 ou 1 et
    représentant un entier écrit en binaire. Renvoie l'écriture
    décimale de l'entier positif dont la représentation binaire
    est donnée par le tableau T
    """
    if len(T) == 0:
        return None

    decimale  = 0
    puissance = len(T) - 1
    for i in T:
        if i not in [0,1]:
            return None
        decimale  += i * (2 ** puissance)
        puissance -= 1
    return decimale

assert convertir([]) == None
assert convertir([1, 0, 1, 0, 2, 1, 1]) == None
assert convertir([1]) == 1
assert convertir([1, 1]) == 3
assert convertir([1, 0, 1]) == 5
assert convertir([1, 0, 1, 0, 0, 1, 1]) == 83
assert convertir([1, 0, 0, 0, 0, 0, 1, 0]) == 130


def tri_insertion(L):
    n = len(L)

    # cas du tableau vide
    if n == 0:
        return L

    for j in range(1,n):
        e = L[j]
        i = j

    # A l'etape j, le sous-tableau L[0,j-1] est trie
    # et on insere L[j] dans ce sous-tableau en determinant
    # le plus petit i tel que 0 <= i <= j et L[i-1] > L[j].
        while  i > 0 and L[i-1] > L[j]:
            i = i - 1

        # si i != j, on decale le sous tableau L[i,j-1] d'un cran
        # vers la droite et on place L[j] en position i
        if i != j:
            for k in range(j,i,-1):
                L[k] = L[k-1]
            L[i] = e
    return L

assert tri_insertion([]) == []
assert tri_insertion([2]) == [2]
assert tri_insertion([2,-1]) == [-1, 2]
assert tri_insertion([2,5,-1,7,0,28]) == [-1, 0, 2, 5, 7, 28]
assert tri_insertion([10,9,8,7,6,5,4,3,2,1,0]) == [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
