def fusion(L1,L2):
    n1 = len(L1)
    n2 = len(L2)
    L12 = [0]*(n1+n2)
    i1 = 0
    i2 = 0
    i = 0
    while i1 < n1 and i2 < n2 :
        if L1[i1] < L2[i2]:
            L12[i] = L1[i1]
            i1 = i1 + 1
        else:
            L12[i] = L2[i2]
            i2 = i2 + 1
        i += 1
    while i1 < n1:
    	L12[i] = L1[i1]
    	i1 = i1 + 1
    	i = i + 1
    while i2 < n2:
    	L12[i] = L2[i2]
    	i2 = i2 + 1
    	i = i + 1
    return L12

assert fusion([],[]) == []
assert fusion([],[0]) == [0]
assert fusion([1,6,10],[0,7,8,9]) == [0, 1, 6, 7, 8, 9, 10]
assert fusion([3, 5], [2, 5]) == [2, 3, 5, 5]
assert fusion([-2, 4], [-3, 5, 10]) == [-3, -2, 4, 5, 10]
assert fusion([4], [2, 6]) == [2, 4, 6]


def rom_to_dec(nombre):
    """ Renvoie l’écriture décimale du nombre donné en chiffres romains """
    dico = { "I":1, "V":5, "X":10, "L":50, "C":100, "D":500, "M":1000 }
    if len(nombre) == 1:
        return dico[nombre]
    else:
        ### on supprime le premier caractère de la chaîne contenue dans la variable nombre
        ### et cette nouvelle chaîne est enregistrée dans la variable nombre_droite
        nombre_droite = nombre[1:]

        if dico[nombre[0]] >= dico[nombre[1]]:
            return dico[nombre[0]] + rom_to_dec(nombre_droite)
        else:
            return -dico[nombre[0]] + rom_to_dec(nombre_droite)

assert rom_to_dec("II") == 2
assert rom_to_dec("IX") == 9
assert rom_to_dec("CXLII") == 142
assert rom_to_dec("MMMMDCCCLXXXVIII") == 4888
assert rom_to_dec("MDXV") == 1515
assert rom_to_dec("MMII") == 2002
assert rom_to_dec("DCLXVI") == 666
assert rom_to_dec("DIX") == 509
assert rom_to_dec("XV") == 15
assert rom_to_dec("XIV") == 14
assert rom_to_dec("XIII") == 13
assert rom_to_dec("XII") == 12
assert rom_to_dec("XI") == 11