def taille(arbre : dict, lettre : str) :
    """ renvoie la taille de l’arbre à savoir le nombre total de nœud."""
    if lettre == '':
        return 0
    if lettre in arbre:
        return 1 + taille(arbre, arbre[lettre][0]) + taille(arbre, arbre[lettre][1])
    else:
        return 0

a = {'F':['B','G'], 'B':['A','D'], 'A':['',''], 'D':['C','E'], \
    'C':['',''], 'E':['',''], 'G':['','I'], 'I':['','H'], \
    'H':['','']}

assert taille({'H':['','']}, 'H') == 1
assert taille({'H':['','']}, 'A') == 0
assert taille(a, 'F') == 9
assert taille(a, 'B') == 5
assert taille(a, 'G') == 3


def tri_iteratif(tab):
    for k in range(len(tab)-1, 0, -1):
        imax = k
        for i in range(0 , k):
            if tab[i] > tab[imax] :
                imax = i
        if tab[imax] > tab[k] :
            tab[k] , tab[imax] = tab[imax] , tab[k]
    return tab

assert tri_iteratif([]) == []
assert tri_iteratif([41]) == [41]
assert tri_iteratif([41, 55]) == [41, 55]
assert tri_iteratif([41, 55, 21, 18, 12, 6, 25]) == [6, 12, 18, 21, 25, 41, 55]
