def xor(tab1 : list, tab2 : list) -> list:
    """ renvoie un tableau où l’élément situé à position i est le résultat, par l’opérateur « ou exclusif », des
    éléments à la position i des tableaux passés en paramètres."""
    if len(tab1) != len(tab2):
        return []
    tab = []
    for i in range(len(tab1)):
        if tab1[i] != tab2[i]:
            tab.append(1)
        else:
            tab.append(0)
    return tab

assert xor([], []) == []
assert xor([1, 0, 1, 0], [0, 1]) == []
assert xor([1, 0, 1, 0, 1, 1, 0, 1], [0, 1, 1, 1, 0, 1, 0, 0]) == [1, 1, 0, 1, 1, 0, 0, 1]
assert xor([1, 1, 0, 1], [0, 0, 1, 1]) == [1, 1, 1, 0]


class Carre:
    def __init__(self, tableau = [[]]):
        self.ordre = len(tableau)
        self.valeurs = tableau

    def affiche(self):
        '''Affiche un carré'''
        for i in range(self.ordre):
            print(self.valeurs[i])

    def somme_ligne(self, i):
        '''Calcule la somme des valeurs de la ligne i'''
        return sum(self.valeurs[i])

    def somme_col(self, j):
        '''calcule la somme des valeurs de la colonne j'''
        return sum([self.valeurs[i][j] for i in range(self.ordre)]) # attention aux indices !

def est_magique(carre):
    n = carre.ordre
    s = carre.somme_ligne(0)

    #test de la somme de chaque ligne
    for i in range(0, n):
        if carre.somme_ligne(i) != s:
            return False

    #test de la somme de chaque colonne
    for j in range(n):
        if carre.somme_col(j) != s:
            return False

    #test de la somme de chaque diagonale
    if sum([carre.valeurs[n-1-k][k] for k in range(n)]) != s:
            return False
    if sum([carre.valeurs[k][n-1-k] for k in range(n)]) != s:
            return False

    return True

#assert est_magique(Carre([[], []])) == False
assert est_magique(Carre([[1,1], [1,1]])) == True
assert est_magique(Carre([[2,9,4], [7,5,3], [6,1,8]])) == True
assert est_magique(Carre([[4,5,16,9], [14,7,2,11], [3,10,15,6], [13,12,8,1]])) == False
