def nombre_de_mots(phrase : str) -> int:
    """ renvoie le nombre de mots présents dans cette phrase."""
    total = 0
    for i in range(len(phrase)):
        if phrase[i] == ' ':
            total += 1
        elif phrase[i] in ['!', '?']:
            if i != len(phrase)-1:
                total -= 1
    if phrase[len(phrase)-1] == '.':
        total += 1
    return total

assert nombre_de_mots('Le point d exclamation est separe !') == 6
assert nombre_de_mots('Il y a un seul espace entre les mots !') == 9
assert nombre_de_mots('Le point final est colle au dernier mot.') == 8
assert nombre_de_mots('Le point final. Le point d exclamation !') == 7
assert nombre_de_mots('Gilbouze macarbi acra cor ed filbuzine ?') == 6
assert nombre_de_mots('Le point d interrogation ? Le point d exclamation !') == 8


class Noeud:
    '''
    Classe implémentant un noeud d'arbre binaire
    disposant de 3 attributs :
    - valeur : la valeur de l'étiquette,
    - gauche : le sous-arbre gauche.
    - droit : le sous-arbre droit.
    '''
    def __init__(self, v, g, d):
        self.valeur = v
        self.gauche = g
        self.droite = d

class ABR:
    '''
    Classe implémentant une structure
    d'arbre binaire de recherche.
    '''

    def __init__(self):
        '''Crée un arbre binaire de recherche vide'''
        self.racine = None

    def est_vide(self):
        '''Renvoie True si l'ABR est vide et False sinon.'''
        return self.racine is None

    def parcours(self, tab = []):
        '''
	  Renvoie la liste tab complétée avec tous les
        éléments de
        l'ABR triés par ordre croissant.
        '''
        if self.est_vide():
            return tab
        else:
            self.racine.gauche.parcours(tab)
            tab.append(self.racine.valeur)
            self.racine.droite.parcours(tab)
            return tab

    def insere(self, element):
        '''Insère un élément dans l'arbre binaire de recherche.'''
        if self.est_vide():
            self.racine = Noeud(element, ABR(), ABR())
        else:
            if element < self.racine.valeur:
                self.racine.gauche.insere(element)
            else :
                self.racine.droite.insere(element)

    def recherche(self, element):
        '''
        Renvoie True si element est présent dans l'arbre
        binaire et False sinon.
        '''
        if self.est_vide():
            return False
        else:
            if element < self.racine.valeur:
                return self.racine.gauche.recherche(element)
            elif element > self.racine.valeur:
                return self.racine.droite.recherche(element)
            else:
                return True

a = ABR()
assert a.est_vide() == True
assert a.parcours() == []
assert a.recherche(4) == False

a.insere(7)
a.insere(3)
a.insere(9)
a.insere(1)
a.insere(9)
assert a.parcours() == [1, 3, 7, 9, 9]
assert a.recherche(4) == False
assert a.recherche(3) == True
