def recherche(tab : int,  n : int) ->int:
    """ effectue une recherche dichotomique du nombre entier n dans le tableau non vide tab.
    doit renvoyer un indice correspondant au nombre cherché s’il est dans le tableau, -1 sinon."""
    gauche = 0
    droite = len(tab) - 1
    while gauche <= droite:
        milieu = (gauche + droite) // 2
        if tab[milieu] == n:
            return milieu
        if tab[milieu] < n:
            gauche = milieu + 1
        else:
            droite = milieu - 1
    return -1

assert recherche([], 5) == -1
assert recherche([1,2,2,3], 2) == 1
assert recherche([2, 3, 4, 5, 6], 2) == 0
assert recherche([2, 3, 4, 5, 6], 6) == 4
assert recherche([2, 3, 4, 5, 6], 5) == 3
assert recherche([2, 3, 4, 6, 7], 5) == -1


ALPHABET='ABCDEFGHIJKLMNOPQRSTUVWXYZ'

def position_alphabet(lettre):
    return ALPHABET.find(lettre)

def cesar(message, decalage):
    resultat = ''
    for lettre in message :
        if lettre in ALPHABET :
            indice = (position_alphabet(lettre) + decalage) % 26
            resultat = resultat + ALPHABET[indice]
        else:
            resultat = resultat + lettre
    return resultat

assert cesar('BONJOUR A TOUS. VIVE LA MATIERE NSI !',4) == 'FSRNSYV E XSYW. ZMZI PE QEXMIVI RWM !'
assert cesar('GTSOTZW F YTZX. ANAJ QF RFYNJWJ SXN !',-5) == 'BONJOUR A TOUS. VIVE LA MATIERE NSI !'