def calcul(n : int) ->list:
    """renvoie la liste des valeurs Un , en partant de k et jusqu’à atteindre 1.
    U0 = k , où k est un entier choisi initialement ;
    Un+1 = Un / 2 si Un est pair ;
    Un+1 = 3×Un + 1 si Un est impair."""
    if n < 1:
        return []
    liste = [n]
    while liste[len(liste) - 1] != 1:
        prev = len(liste) - 1
        if liste[prev] % 2 == 0:
            liste.append(liste[prev] // 2)
        else:
            liste.append((3 *liste[prev]) + 1)
    return liste

assert calcul(-1) == []
assert calcul(7) == [7, 22, 11, 34, 17, 52, 26, 13, 40, 20, 10, 5, 16, 8, 4, 2, 1]


dico = {"A":1, "B":2, "C":3, "D":4, "E":5, "F":6, "G":7, \
        "H":8, "I":9, "J":10, "K":11, "L":12, "M":13, \
        "N":14, "O":15, "P":16, "Q":17, "R":18, "S":19, \
        "T":20, "U":21,"V":22, "W":23, "X":24, "Y":25, "Z":26}

def est_parfait(mot) :
    #mot est une chaîne de caractères (en lettres majuscules)
    code_c = ""
    code_a = 0
    for c in mot :
        code_c = code_c + str(dico[c])
        code_a = code_a + dico[c]
    code_c = int(code_c)
    if code_c % code_a == 0 :
        mot_est_parfait = True
    else :
        mot_est_parfait = False
    return [code_a, code_c, mot_est_parfait]

assert est_parfait("PAUL") == [50, 1612112, False]
assert est_parfait("ALAIN") == [37, 1121914, True]
