def RechercheMinMax(tab : list) -> dict:
    """ renvoie la plus petite et la plus grande valeur du tableau sous la
    forme d’un dictionnaire à deux clés ‘min’ et ‘max’. """
    if len(tab) == 0:
        return {'min': None, 'max': None}
    min = max = tab[0]
    for i in tab:
        if i < min:
            min = i
        elif i > max:
            max = i
    return {'min': min, 'max': max}

assert RechercheMinMax([0, 1, 4, 2, -2, 9, 3, 1, 7, 1]) == {'min': -2, 'max': 9}
assert RechercheMinMax([]) == {'min': None, 'max': None}


class Carte:
    """Initialise Couleur (entre 1 à 4), et Valeur (entre 1 à 13)"""
    def __init__(self, c, v):
        assert 1 <= c <= 4 and 1 <= v <= 13
        self.Couleur = c
        self.Valeur = v

    """Renvoie le nom de la Carte As, 2, ... 10, Valet, Dame, Roi"""
    def getNom(self):
        if ( self.Valeur > 1 and self.Valeur < 11):
            return str(self.Valeur)
        elif self.Valeur == 11:
            return "Valet"
        elif self.Valeur == 12:
            return "Dame"
        elif self.Valeur == 13:
            return "Roi"
        else:
            return "As"

    """Renvoie la couleur de la Carte (parmi pique, coeur, carreau, trefle"""
    def getCouleur(self):
        return ['pique', 'coeur', 'carreau', 'trefle' ][self.Couleur - 1]

class PaquetDeCarte:
    def __init__(self):
        self.contenu = []

    """Remplit le paquet de cartes"""
    def remplir(self):
        for couleur in range(1,5):
            for nom in range(1, 14):
                self.contenu.append(Carte(couleur, nom))

    """Renvoie la Carte qui se trouve à la position donnée"""
    def getCarteAt(self, pos):
        assert 0 < pos < 4 * 13
        return self.contenu[pos-1]

unPaquet = PaquetDeCarte()
unPaquet.remplir()

uneCarte = unPaquet.getCarteAt(1)
assert uneCarte.getNom() == "As"
assert uneCarte.getCouleur() == "pique"

uneCarte = unPaquet.getCarteAt(2)
assert uneCarte.getNom() == '2'
assert uneCarte.getCouleur() == "pique"

uneCarte = unPaquet.getCarteAt(14)
assert uneCarte.getNom() == "As"
assert uneCarte.getCouleur() == "coeur"

uneCarte = unPaquet.getCarteAt(20)
assert uneCarte.getNom() == '7'
assert uneCarte.getCouleur() == "coeur"

uneCarte = unPaquet.getCarteAt(27)
assert uneCarte.getNom() == "As"
assert uneCarte.getCouleur() == "carreau"

