a = {'F':['B','G'], 'B':['A','D'], 'A':['',''], 'D':['C','E'], \
    'C':['',''], 'E':['',''], 'G':['','I'], 'I':['','H'], 'H':['','']}
b = {'A':['','']}
c = {'A':['B',''], 'B':['','']}
d = {}

def taille(arbre : dict, lettre : str) -> int:
    """ renvoie la taille de l’arbre à savoir le nombre total de nœud."""
    def reccursif(arbre : dict, noeud : str, total : list = [0]) -> int:
        if noeud in arbre:
            total[0] += 1
            if arbre[noeud][0] != '':
                reccursif(arbre, arbre[noeud][0], total)
            if arbre[noeud][1] != '':
                reccursif(arbre, arbre[noeud][1], total)
        return total[0]

    return reccursif(arbre, lettre) if len(arbre) else 0

assert taille(d, 'A') == 0
assert taille(b, 'A') == 1
assert taille(b, 'B') == 0
assert taille(c, 'A') == 2
assert taille(a, 'F') == 9

def tri_iteratif(tab : list) -> list:
    for k in range(len(tab), 0, -1):
        imax = k-1
        for i in range(0, k-1):
            if tab[i] > tab[imax]:
                imax = i
        if tab[imax] > tab[k-1]:
            tab[k-1], tab[imax] = tab[imax], tab[k-1]
    return tab

assert tri_iteratif([]) == []
assert tri_iteratif([1]) == [1]
assert tri_iteratif([1, 2]) == [1, 2]
assert tri_iteratif([2, 1]) == [1, 2]
assert tri_iteratif([41, 55, 21, 18, 12, 6, 25]) == [6, 12, 18, 21, 25, 41, 55]
