def occurrence_max(chaine : str):
    """ renvoie le caractère le plus fréquent de la chaîne. La chaine ne contient
    que des lettres en minuscules sans accent."""
    max = 0
    caractere = ''

    occurrence = {}
    for i in chaine:
        if i in occurrence:
            occurrence[i] += 1
        else:
            occurrence[i] = 1
        if max < occurrence[i]:
            max += 1
            caractere = i

    return caractere

assert occurrence_max('') == ''
assert occurrence_max('!!!!!!!!!!') == '!'
assert occurrence_max('+++****+++') == '+'
assert occurrence_max('je suis en terminale et je passe le bac et je souhaite poursuivre des etudes pour devenir expert en informatique') == 'e'

def nbLig(image : list) -> int:
    '''renvoie le nombre de lignes de l'image'''
    return len(image)

def nbCol(image : list) -> int:
    '''renvoie la largeur de l'image'''
    return len(image[0])    # vérifier que la taille de la liste n'est pas nulle !!

def negatif(image : list) -> list:
    '''renvoie le négatif de l'image sous la forme
       d'une liste de listes'''
    L = [[0 for k in range(nbCol(image))] for i in range(nbLig(image))] # on créé une image de 0 aux mêmes dimensions que le paramètre image
    for i in range(nbLig(image)):
        for j in range(nbCol(image)):
            L[i][j] = 255 - image[i][j]
    return L

def binaire(image : list, seuil : int) -> list:
    '''renvoie une image binarisée de l'image sous la forme
       d'une liste de listes contenant des 0 si la valeur
       du pixel est strictement inférieure au seuil
       et 1 sinon'''
    L = [[0 for k in range(nbCol(image))] for i in range(nbLig(image))] # on crée une image de 0 aux mêmes dimensions que le paramètre image
    for i in range(nbLig(image)):
        for j in range(nbCol(image)):
            if image[i][j] < seuil :
                L[i][j] = 1
            else:
                L[i][j] = 0
    return L

assert nbLig([[0, 2],[2, 0],[3, 3]]) == 3
assert nbCol([[0, 2],[2, 0],[3, 3]]) == 2
assert negatif([[0, 2],[2, 0],[3, 3]]) == [[255, 253],[253, 255],[252, 252]]
assert binaire([[0, 2],[2, 0],[3, 3]], 0) == [[0, 0],[0, 0],[0, 0]]
assert binaire([[0, 2],[2, 0],[3, 3]], 1) == [[1, 0],[0, 1],[0, 0]]
assert binaire([[0, 2],[2, 0],[3, 3]], 3) == [[1, 1],[1, 1],[0, 0]]
assert binaire([[0, 2],[2, 0],[3, 3]], 4) == [[1, 1],[1, 1],[1, 1]]

img = [[20, 34, 254, 145, 6], [23, 124, 287, 225, 69], [197, 174, 207, 25, 87], [255, 0, 24, 197, 189]]
assert nbLig(img) == 4
assert nbCol(img) == 5
assert negatif(img) == [[235, 221, 1, 110, 249], [232, 131, -32, 30, 186], [58, 81, 48, 230, 168], [0, 255, 231, 58, 66]]
assert binaire(img, 120) == [[1, 1, 0, 0, 1], [1, 0, 0, 0, 1], [0, 0, 0, 1, 1], [0, 1, 1, 0, 0]]
