def mini(releve : list, date : list) -> tuple:
    """ renvoie la plus petite valeur relevée
    au cours de la période et l’année correspondante."""
    # les 2 listes doivant avoir la même taille <> 0
    if len(releve) != len(date):
        return None
    if len(releve) == 0 or len(date) == 0:
        return None

    idx = 0
    min = releve[idx]
    for i in range(len(releve)):
        if releve[i] < min:
            idx = i
            min = releve[idx]
    return (releve[idx], date[idx])

t_moy  = [14.9, 13.3, 13.1, 12.5, 13.0, 13.6, 13.7]
annees = [2013, 2014, 2015, 2016, 2017, 2018, 2019]

assert mini(t_moy, annees) == (12.5, 2016)

def inverse_chaine(chaine):
    result = ''
    for caractere in chaine:
       result = caractere + result
    return result

def est_palindrome(chaine : str) -> bool:
    inverse = inverse_chaine(chaine)
    return inverse == chaine

def est_nbre_palindrome(nbre : int) -> bool:
    chaine = str(nbre)
    return est_palindrome(chaine)

assert inverse_chaine('x') == 'x'
assert est_palindrome('x') == True
assert inverse_chaine(inverse_chaine('abc')) == 'abc'
assert inverse_chaine('bac') == 'cab'
assert est_palindrome('NSI') == False
assert est_palindrome('ISN-NSI') == True
assert est_nbre_palindrome(214312) == False
assert est_nbre_palindrome(213312) == True
