def recherche(tab : list, n : int) -> int:
    """ effectue une recherche dichotomique du nombre entier n dans le tableau non vide tab.
    Cette fonction doit renvoyer un indice correspondant au nombre cherché s’il est dans le tableau, -1 sinon."""
    inf = 0
    sup = len(tab) - 1
    while inf <= sup:
        m = (inf + sup) // 2
        if tab[m] == n:
            return m
        if tab[m] < n:
            inf = m + 1
        else:
            sup = m - 1
    return -1

assert recherche([], 2) == -1
assert recherche([2], 2) == 0
assert recherche([2, 3], 2) == 0
assert recherche([2, 3], 3) == 1
assert recherche([2, 3, 4, 5], 3) == 1
assert recherche([2, 3, 4, 5], 4) == 2
assert recherche([2, 3, 4, 5, 6], 4) == 2
assert recherche([2, 3, 4, 5, 6], 5) == 3
assert recherche([2, 3, 4, 6, 7], 5) == -1

ALPHABET='ABCDEFGHIJKLMNOPQRSTUVWXYZ'

def position_alphabet(lettre : str) -> int:
    return ALPHABET.find(lettre)

def cesar(message : str, decalage : int) -> str:
    resultat = ''
    for lettre in message :
        if lettre in ALPHABET :
            indice   = (position_alphabet(lettre) + decalage) % 26
            resultat = resultat + ALPHABET[indice]
        else:
            resultat = resultat + lettre
    return resultat

assert cesar('BONJOUR A TOUS. VIVE LA MATIERE NSI !', 4) == 'FSRNSYV E XSYW. ZMZI PE QEXMIVI RWM !'
assert cesar(cesar('BONJOUR A TOUS. VIVE LA MATIERE NSI !', 4), -4) == 'BONJOUR A TOUS. VIVE LA MATIERE NSI !'
assert cesar('GTSOTZW F YTZX. ANAJ QF RFYNJWJ SXN !', -5) == 'BONJOUR A TOUS. VIVE LA MATIERE NSI !'
assert cesar(cesar('GTSOTZW F YTZX. ANAJ QF RFYNJWJ SXN !', -5), 5) == 'GTSOTZW F YTZX. ANAJ QF RFYNJWJ SXN !'
