def RechercheMinMax(tab : list) -> dict:
    """ renvoie la plus petite et la plus grande valeur du tableau
    sous la forme d’un dictionnaire à deux clés ‘min’ et ‘max’."""
    if len(tab) == 0:
        return {'min': None, 'max': None}

    min, max = tab[0], tab[0]
    for i in tab:
        if i < min:
            min = i
        if i > max:
            max = i
    return {'min': min, 'max': max}

assert RechercheMinMax([0, 1, 4, 2, -2, 9, 3, 1, 7, 1]) == {'min': -2, 'max': 9}
assert RechercheMinMax([0]) == {'min': 0, 'max': 0}
assert RechercheMinMax([]) == {'min': None, 'max': None}

class Carte:
    """Initialise Couleur (entre 1 à 4), et Valeur (entre 1 à 13)"""
    def __init__(self, c, v):
        self.Couleur = c
        self.Valeur  = v

    """Renvoie le nom de la Carte As, 2, ... 10, Valet, Dame, Roi"""
    def getNom(self):
        if ( self.Valeur > 1 and self.Valeur < 11):
            return str( self.Valeur)
        elif self.Valeur == 11:
            return "Valet"
        elif self.Valeur == 12:
            return "Dame"
        elif self.Valeur == 13:
            return "Roi"
        else:
            return "As"

    """Renvoie la couleur de la Carte (parmi pique, coeur, carreau, trefle"""
    def getCouleur(self):
        #return ['pique', 'coeur', 'carreau', 'trefle'][self.Couleur]
        return self.Couleur

class PaquetDeCarte:
    def __init__(self):
        self.contenu = []

    """Remplit le paquet de cartes"""
    def remplir(self):
        for c in ['pique', 'coeur', 'carreau', 'trefle']:
            for v in range(1, 15):
                self.contenu.append(Carte(c, v))

    """Renvoie la Carte qui se trouve à la position donnée"""
    def getCarteAt(self, pos):
        try:
            return self.contenu[pos-1]
        except IndexError:
            pass

unPaquet = PaquetDeCarte()
unPaquet.remplir()
try:
    assert unPaquet.getCarteAt(20).getNom() == '6'
    assert unPaquet.getCarteAt(20).getCouleur() == 'coeur'
    assert unPaquet.getCarteAt(1).getNom() == 'As'
    assert unPaquet.getCarteAt(1).getCouleur() == 'pique'
    assert unPaquet.getCarteAt(111).getNom() == '1'
    assert unPaquet.getCarteAt(-1).getCouleur() == 'pique'
except AttributeError:
    print("La carte n'existe pas")
